实验名称
----

使用 Python 操作 MongoDB

### 实验目的

1、掌握 Python 操作 MongoDB

2、掌握 MongoDB 查询常用方法

### 实验背景

MongoDB 是由 C++ 语言编写的非关系型数据库，是一个基于分布式文件存储的开源数据库系统，其内容存储形式类似 JSON 对象，它的字段值可以包含其他文档、数组及文档数组，非常灵活。

MongoDB 是一个介于关系数据库和非关系数据库之间的产品，是非关系数据库当中功能最丰富，最像关系数据库的。

### 实验原理

pymongo 是 Python 访问 MongoDB 的模块，该模块定义了一个操作 MongoDB 的类 PyMongoClient，包含了数据库连接管理、集合管理、索引管理、增删改查、文件操作、聚合操作等方法。

### 实验环境

Ubuntu18.04

Python3.8

MongoDB6.0.8

### 建议课时

1课时

### 实验步骤

一、编写 Python 程序

0. 启动 mongod 服务

   （1）在指定目录下创建 mongodb 文件夹、其子文件夹 data、log 以及文件 mongodb.log

   ```sh
   cd /home/ubuntu
   mkdir -p mongodb/data
   mkdir -p mongodb/log
   touch mongodb/log/mongodb.log
   ```

   （2）执行 mongod 命令以启动 mongod 服务

   ```sh
   mongod --dbpath /home/ubuntu/mongodb/data --logpath /home/ubuntu/mongodb/log/mongodb.log --logappend --fork # 启动 mongod 服务
   ```

1. 安装 pymongo 依赖

   ```sh
   pip3 install pymongo==4.1.1 # 如果当前环境是 Python3 环境，则使用 pip 关键字
   ```

   ![安装pymongo.png](./pic/07-1-1-安装pymongo.png)

2. 在 `/home/ubuntu` 目录下创建 python文件，命名为 pyinsert.py

   ![07-1-2-新建python文件.png](./pic/07-1-2-新建python文件.png)

   ![07-1-3-命名pyinsert.png](./pic/07-1-3-命名pyinsert.png)

3. 在 pyinsert.py 中编写如下代码

   ```python
   from pymongo import MongoClient
   from random import randint
   
   '''定义用于生成随机名字信息列表'''
   name1 = ["yang ", "li ", "zhou "]
   name2 = ["chao", "hao", "gao", "qi gao", "hao hao", "gao gao", "chao hao", "ji gao", "ji hao", "li gao", "li hao", ]
   provinces = ["guang dong", "guang xi", "shan dong", "shan xi", "he nan"]
   '''连接MongoDB'''
   client = MongoClient('127.0.0.1', 27017)
   db = client.student
   sm = db.smessage
   sm.delete_many({})
   '''循环生成学生信息'''
   for i in range(1, 100):
       name = name1[randint(0, 2)] + name2[randint(0, 10)]
       province = provinces[randint(0, 4)]
       '''学生信息文档'''
       new_student = {
           "name": name,
           "age": randint(1, 30),
           "province": province,
           "subject": [
               {"name": "chinese", "score": randint(0, 100)},
               {"name": "math", "score": randint(0, 100)},
               {"name": "english", "score": randint(0, 100)},
               {"name": "chemic", "score": randint(0, 100)},
           ]}
       print(new_student)
       '''插入MongoDB数据库'''
       sm.insert_one(new_student)
   
   print(sm.estimated_document_count())
   ```

   ![07-1-4-编写代码.png](./pic/07-1-4-编写代码.png)

4. 执行 python 代码

   切换至 pyinsert.py 所在目录下，执行以下命令

   ```sh
   python3 pyinsert.py # 如果当前环境是 Python3 环境，则使用 python 关键字
   ```

   ![07-1-5-运行代码-1.png](./pic/07-1-5-运行代码-1.png)

   ![07-1-5-运行代码-2.png](./pic/07-1-5-运行代码-2.png)

5. 查看插入的数据的数据类型

   （1）进入 mongo shell

   ```sh
   mongosh # 启动 mongo shell
   ```
   
   ![07-1-6-进入mongoshell.png](./pic/07-1-6-进入mongoshell.png)
   
   （2）使用 findOne() 方法查询第一条文档
   
      ```js
   use student
   db.smessage.findOne({})
      ```
   
      ![07-1-8-查询第一条文档.png](./pic/07-1-8-查询第一条文档.png)

二、在 mongodb shell 终端查询

1. 查询广东学生的平均年龄

   ```js
   db.smessage.aggregate({ $match: { province: 'guang dong' } }, { $group: { _id: '$province', age: { $avg: '$age' } } })
   ```

   ![07-1-9-查询广东学生平均年龄.png](./pic/07-1-9-查询广东学生平均年龄.png)

2. 查询所有省份的平均年龄

   ```js
   db.smessage.aggregate({ $group: { _id: '$province', age: { $avg: '$age' } } })
   ```

   ![07-1-10-查询所有省份平均年龄.png](./pic/07-1-10-查询所有省份平均年龄.png)

3. 查询广东省所有科目的平均成绩

   ```js
   db.smessage.aggregate({ $match: { province: 'guang dong' } }, { $unwind: '$subject' }, { $group: { _id: { province: '$province', sujname: '$subject.name' }, per: { $avg: '$subject.score' } } })
   ```

   ![07-1-11-查询广东所有科目平均成绩.png](./pic/07-1-11-查询广东所有科目平均成绩.png)

4. 在题目3的基础上进行排序

   ```js
   db.smessage.aggregate(
     { $match: { province: 'guang dong' } },
     { $unwind: '$subject' },
     { $group: { _id: { province: '$province', sujname: '$subject.name' }, per: { $avg: '$subject.score' } } },
     { $sort: { per: 1 } }
   )
   ```

   ![07-1-11-查询广东所有科目平均成绩-排序.png](./pic/07-1-11-查询广东所有科目平均成绩-排序.png)

### 实验总结

该实验的主要内容是使用 Python 进行操作 MongoDB，进行数据插入，然后使用 mongo shell 进行数据查询，涉及 find 函数，聚合函数如：estimated_document_count，avg 以及 group 等的使用。